@extends(activeTemplate() .'layouts.master')

@section('content')






    <section class="hero-section"
             style="background: url({{ get_image(config('constants.frontend.banner.path') .'/'. $banner->value->image) }});">
        <div class="hero-area">
            <div id="particles-js"></div>
            <div class="single-hero">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-xl-11 centered">
                            <div class="hero-sub">
                                <div class="table-cell">
                                    <div class="hero-left">
                                        <h4>@lang($banner->value->subtitle)</h4>
                                        <h1>@lang($banner->value->title)</h1>
                                        <p>@lang($banner->value->details)</p>
                                        <a href="{{route('user.register')}}" class="bttn-mid btn-fill"><i
                                                    class="ti-user"></i>Register</a>
                                        <a href="{{route('user.login')}}" class="bttn-mid btn-emt"><i
                                                    class="ti-key"></i>Login</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--/Hero Area-->

    <!--Section-->
    <section class="section-padding-2 gradient-overlay poly-particle">
        <div class="triangle-particle">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-7 centered">
                        <div class="section-title cl-white">
                            <h2>@lang($service_titles->value->title)</h2>
                            <p>@lang($service_titles->value->subtitle)</p>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center centered">
                    @foreach($service as $data)
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6">
                            <div class="single-box">
                                @php echo $data->value->icon; @endphp
                                <h3>@lang($data->value->title)</h3>
                                <p>@lang($data->value->sub_title)</p>
                            </div>
                        </div>
                    @endforeach

                </div>
            </div>
        </div>
    </section><!--/Section-->

    <!--Brands Area-->
    <section class="section-padding blue-bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 centered">
                    <div class="section-title cl-white">

                        <h2>@lang('Payment we accept')</h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                @foreach($gates as $gate)
                    <div class="col-xl-2 col-lg-2 col-md-2 col-sm-6 col-6">
                        <div class="single-brands">
                            <a> <img title="@lang($gate->name)"
                                     src="{{ get_image(config('constants.deposit.gateway.path') .'/'. $gate->image) }}"
                                     alt="">
                            </a></div>
                    </div>
                @endforeach

            </div>

        </div>
    </section><!--/Brands Area-->

    <!--feature Area-->
    <section class="feature-area section-padding-2 gradient-overlay">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 centered wow fadeInUp" data-wow-delay="0.3s">
                    <div class="section-title cl-white">
                        <h2>@lang($how_it_work_title->value->title)</h2>
                        <p>@lang($how_it_work_title->value->subtitle)</p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                @foreach($how_it_work as $data)
                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12 wow fadeInUp" data-wow-delay="0.3s">
                        <div class="single-feature-2 @if($loop->iteration == 1) bottom-after @elseif($loop->iteration == 2) bottom-before @else @endif">
                            @php echo $data->value->icon; @endphp
                            <h4>@lang($data->value->title)</h4>
                            <p>@lang($data->value->sub_title)</p>
                        </div>
                    </div>
                @endforeach


            </div>
        </div>
    </section>

    <!-- Cta -->
    <section class="cta section-padding gradient-overlay">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 cl-white">
                    <div class="dev-first">
                        <div class="section-title mb-10">
                            <h2>@lang($video_section->value->title)</h2>
                        </div>

                        <p> @lang($video_section->value->detail)
                        </p>

                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 cl-white ">


                    <img src="{{ get_image(config('constants.frontend.'. $video_section->key .'.path') .'/'. $video_section->value->image) }}"
                         alt="">
                    <a href="https://www.youtube.com/watch?v=GT6-H4BRyqQ" class="video-popup"><i
                                class="flaticon-visible"></i></a>

                </div>
            </div>
        </div>
    </section>



    <!-- Review Area -->
    <section class="review-area section-padding gradient-overlay ">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-9 col-lg-9 col-md-12 col-sm-12 wow fadeInUp" data-wow-delay="0.4s">
                    <div class="section-title cl-white">
                        <h2>@lang($testimonial_title->value->title)</h2>
                        <p>@lang($testimonial_title->value->subtitle)</p>
                    </div>
                    <div class="testimonials owl-carousel">


                        @foreach($testimonial as $data)
                            <div class="single-review">
                                <div class="reviewer-thumb">
                                    <img src="{{ get_image(config('constants.frontend.testimonial.path') .'/'. $data->value->image) }}"
                                         alt="">
                                    <h3>@lang($data->value->author)</h3>
                                    <span>@lang($data->value->designation)</span>
                                </div>
                                <p>@lang($data->value->quote)</p>
                            </div>

                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section><!-- /Review Area -->

    <!-- Cta -->
    <section class="cta section-padding gradient-overlay"
             style="background: url({{ get_image(config('constants.frontend.'. $call_to_action->key .'.path') .'/'. $call_to_action->value->image) }})">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 centered cl-white">
                    <div class="section-title mb-20">
                        <h2>@lang($call_to_action->value->title)</h2>
                        <p>@lang($call_to_action->value->detail)</p>
                    </div>
                    <a href="{{route('user.register')}}" class="bttn-mid btn-emt">@lang('Register now')</a>
                </div>
            </div>
        </div>
    </section>


    <section class="blog-area section-padding-2 blue-bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 centered wow fadeInUp" data-wow-delay="0.3s">
                    <div class="section-title cl-white">
                        <h2>{{__($blog_title->value->title)}}</h2>
                        <p>{{__($blog_title->value->subtitle)}}</p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">


                @foreach($blogs as $blog)
                    <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 wow fadeInUp" data-wow-delay="0.4s">
                        <div class="single-blog-2">
                            <div class="single-blog-img">
                                <img src="{{ get_image(config('constants.frontend.blog.post.path') .'/'. $blog->value->image) }}"
                                     alt="">
                                <a href="{{ route('singleBlog', [slug($blog->value->title) , $blog->id]) }}"><i
                                            class="flaticon-add"></i></a>
                            </div>
                            <div class="single-blog-content">
                                <div class="blog-meta ">
                                    <span><a><i class="flaticon-calendar"></i>{{\Carbon\Carbon::parse($blog->created_at)->diffForHumans()}}</a></span>

                                </div>
                                <h3>
                                    <a href="{{ route('singleBlog', [slug($blog->value->title) , $blog->id]) }}">@lang($blog->value->title)</a>
                                </h3>
                                <p>{{ \Illuminate\Support\Str::limit(strip_tags($blog->value->body), 160, '...') }}</p>
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>

    <!-- Newslatter -->
    <section class="section-padding gradient-overlay">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 centered cl-white">
                    <div class="section-title mb-20">
                        <h2>@lang("Don't miss any update")</h2>
                    </div>
                    <div class="newslatter">
                        <form action="{{route('subscriber.store')}}" method="post">
                            @csrf
                            <input type="email" name="email" placeholder="@lang('Enter your email')" required>
                            <button type="submit"><i class="fa fa-paper-plane"></i></button>
                        </form>
                        <p><i class="fa fa-info-circle"></i>@lang('We will never send spam')</p>
                    </div>
                </div>
            </div>
        </div>
    </section><!-- /Newslatter -->




@endsection

@push('css')

@endpush


@push('js')
    <script>
        var $portfolio = $('.portfolio');
        if ($.fn.imagesLoaded && $portfolio.length > 0) {
            imagesLoaded($portfolio, function () {
                $portfolio.isotope({
                    itemSelector: '.portfolio-item',
                    filter: '*'
                });
                $(window).trigger("resize");
            });
        }
        $('.portfolio-filter').on('click', 'a', function (e) {
            e.preventDefault();
            $(this).parent().addClass('active').siblings().removeClass('active');
            var filterValue = $(this).attr('data-filter');
            $portfolio.isotope({filter: filterValue});
        });
        // Portfolio popup
        $(".portfolio-gallery").each(function () {
            $(this).find(".popup-gallery").magnificPopup({
                type: "image",
                gallery: {
                    enabled: true
                }
            });
        });
        $('.video-popup').magnificPopup({
            type: 'iframe',
        });
    </script>
@endpush